( function( $ ) {
    /**
     * @param $scope The Widget wrapper element as a jQuery element
     * @param $ The jQuery alias
     */
    var Wcf_Accordion = function ($scope, $) {      
   
        var $wrapper = $scope.find('.elementor-accordion');
        var $items   = $wrapper.find('.elementor-accordion-item');
        
        if($items.length && $wrapper.attr('data-active') === 'yes'){
           $items.find('[data-active="yes"]').addClass('elementor-active');
           $items.find('.elementor-tab-content[data-active="yes"]').addClass('elementor-active').slideToggle();               
        }
        
        $scope.find('.elementor-tab-title').on('click',function(){       
            $(this).toggleClass("elementor-active").next(".elementor-tab-content").slideToggle().parent().siblings().find(".elementor-tab-content").slideUp().prev().removeClass("elementor-active");            
        });
       
    };
    function wcf_ess_addScript(path,id) {
        var head = document.getElementsByTagName("head")[0];
        var s = document.createElement("script");
        s.type = "text/javascript";
        s.src = path;
        s.id = id;
        head.appendChild(s);
    } 
    // Make sure you run this code under Elementor.
    $( window ).on( 'elementor/frontend/init', function() {

        const icon_box  =  elementorModules.frontend.handlers.Base.extend({
            bindEvents : function bindEvents() {
            this.run();            
            },
            
            run : function(){
      
            if(this.getElementSettings('wcf_enable_bottom_top_scroll') === 'yes'){   
                
                if(this.findElement('a').length){
                
                    let target = this.findElement('a').attr('href');                      
                    if ( !target ){                        
                        this.findElement('a').on('click', function(e){
                            e.preventDefault();
                            if (typeof(gsap) === "object") {
                                gsap.to(window, {duration: 1, scrollTo:{y:'body', offsetY:70}});
                            }
                        });
                    }else{
                    
                        try{
                            if (typeof(gsap) === "object") {
                            let element = document.querySelector(this.findElement('a').attr('href'));
                            let linkST = ScrollTrigger.create({
                              trigger: element,
                              start: "top top",
                            });
                            
                            ScrollTrigger.create({
                              trigger: element,
                              start: "top center",
                              end: "bottom center"                          
                            });
                            
                            this.findElement('a').on('click', function(e){
                                e.preventDefault();   
                                gsap.to(window, {
                                    duration: 0.1,
                                    scrollTo: linkST.start,
                                    overwrite: "auto"
                                });                           
                            });
                        }
                            
                        }catch (e) {}
                    }                                       
                    
                }else{
                    
                   this.findElement('.elementor-widget-container').css({'cursor':'pointer'});
                   this.findElement('.elementor-widget-container').on('click' , function(e){
                        e.preventDefault();  
                        if (typeof(gsap) === "object") {
                            gsap.to(window, {duration: 1, scrollTo:{y:'body', offsetY:70}});
                        }
                   }); 
                }
            } 
           
            }
        
        })
    
        elementorFrontend.hooks.addAction( 'frontend/element_ready/accordion.skin-wcf-accordion', Wcf_Accordion );
        
        const addIcon_BoxHandler = ( $element ) => {
            elementorFrontend.elementsHandler.addHandler( icon_box, {
                $element,
            } );
        };
         
        elementorFrontend.hooks.addAction( 'frontend/element_ready/icon-box.default', addIcon_BoxHandler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/wcf--button.default', addIcon_BoxHandler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/button.default', addIcon_BoxHandler );
    } );
} )( jQuery );
